#ifndef __UART_H
#define __UART_H

/* 

	UART drivers, by Mauro Grassi, 2010.
	
	
*/

#include "hardwarestate.h"
#include "vm.h"

#define 		BAUD_RATE_FACTOR			10.0
#define 		LOWEST_BAUD_RATE			300.0
#define 		LOWEST_BAUD_REGISTER_VALUE	((GetInstructionClock()/LOWEST_BAUD_RATE)-1)

void 			UARTRxPipePut(VIRTUAL_MACHINE* vm, unsigned char g);
unsigned char 	UARTRxPipeGet(VIRTUAL_MACHINE* vm);
unsigned char 	disFix(unsigned char x);
void 			disAUART(unsigned char x);
void 			disWUART(unsigned int x);
void 			disDWUART(unsigned long x);
void 			disDecUART(unsigned long x);
void 			powerUART(unsigned char on);
void 			putcUART(unsigned char c);
void 			putrsUART(const rom char* instr);
void 			putsUART(char* instr);
void			initUARTState(VIRTUAL_MACHINE* vm, UART_DESCRIPTOR* systemState);
void 			closeUARTState(VIRTUAL_MACHINE* vm, UART_DESCRIPTOR* systemState);
void 			putsSizeUART(int size, unsigned char* instr);
void			clearUARTRx(VIRTUAL_MACHINE* vm);
unsigned char 	getUARTError(VIRTUAL_MACHINE* vm);
unsigned char 	receivedNMEAUART(VIRTUAL_MACHINE* vm);

#endif
